﻿//FloorDamagePercent

/*:ja

 * @plugindesc 床ダメージを割合にするプラグイン
 * @author 霧島万　（ツイッター　yurugatinoeru）
 * @help
 *
 * @param PercentOfFloorDamage
 * @desc 床ダメージの最大HPに対する割合です。
 * @default 10

*/


(function(_global) {
	var CPObasicFloorDamage = Game_Actor.prototype.basicFloorDamage;
	
	//プラグインパラメータの定義
	var parameters = PluginManager.parameters('FloorDamagePercent');
	var PercentOfFloorDamage = Number(parameters['PercentOfFloorDamage']);

	Game_Actor.prototype.basicFloorDamage = function() {
		//とりあえず元のを呼んでおく
		var defaultBasicFloorDamage = CPObasicFloorDamage.call(this);
		
		
		//実際の処理
		var hp = this.mhp;
		var damage = hp*PercentOfFloorDamage/100
		return damage;
	};

})();